﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using AZVIC.Ei8htPOS.Utilities;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.POSRetail.Constants;
using AZVIC.Ei8htPOS.POSRetail;

namespace AZVIC.Ei8htPOS.POSRetail.Controls
{
    /// <summary>
    /// Interaction logic for MiscItems.xaml
    /// </summary>
    public partial class SelectPrinter : Window
    {
        public SelectPrinter()
        {
            InitializeComponent();
            LoadCurrentPrinters();
        }

        private void LoadCurrentPrinters()
        {
            //Properties.
            cbInvoice.SelectedItem = Properties.Settings.Default.InvoicePrinter;
            cbBarcode.SelectedItem = Properties.Settings.Default.BarcodePrinter;

        }

        private void btnSave_Click(object sender, RoutedEventArgs e)
        {
            if (cbInvoice.SelectedIndex == -1)
            {
                MessageBox.Show("Please select valid Invoice Printer", "Ei8ht POS", MessageBoxButton.OK, MessageBoxImage.Error, MessageBoxResult.OK);
                return;
            }

            if (cbBarcode.SelectedIndex == -1)
            {
                MessageBox.Show("Please select valid Barcode Printer", "Ei8ht POS", MessageBoxButton.OK, MessageBoxImage.Error, MessageBoxResult.OK);
                return;
            }

            Properties.Settings.Default.InvoicePrinter = cbInvoice.SelectedItem.ToString();
            Properties.Settings.Default.BarcodePrinter = cbBarcode.SelectedItem.ToString();
            Properties.Settings.Default.Save();
            this.Tag = true;
            this.Close();
        }
        private void btnCancel_Click(object sender, RoutedEventArgs e)
        {
            this.Tag = false;
            this.Close();
        }
    }
}
